<?php
/**
 * DowngradeBillingPlanInformation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * DowngradeBillingPlanInformation Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DowngradeBillingPlanInformation implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'downgradeBillingPlanInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'downgrade_event_type' => '?string',
        'plan_information' => '\DocuSign\eSign\Model\PlanInformation',
        'promo_code' => '?string',
        'sale_discount' => '?string',
        'sale_discount_periods' => '?string',
        'sale_discount_type' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'downgrade_event_type' => null,
        'plan_information' => null,
        'promo_code' => null,
        'sale_discount' => null,
        'sale_discount_periods' => null,
        'sale_discount_type' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'downgrade_event_type' => 'downgradeEventType',
        'plan_information' => 'planInformation',
        'promo_code' => 'promoCode',
        'sale_discount' => 'saleDiscount',
        'sale_discount_periods' => 'saleDiscountPeriods',
        'sale_discount_type' => 'saleDiscountType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'downgrade_event_type' => 'setDowngradeEventType',
        'plan_information' => 'setPlanInformation',
        'promo_code' => 'setPromoCode',
        'sale_discount' => 'setSaleDiscount',
        'sale_discount_periods' => 'setSaleDiscountPeriods',
        'sale_discount_type' => 'setSaleDiscountType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'downgrade_event_type' => 'getDowngradeEventType',
        'plan_information' => 'getPlanInformation',
        'promo_code' => 'getPromoCode',
        'sale_discount' => 'getSaleDiscount',
        'sale_discount_periods' => 'getSaleDiscountPeriods',
        'sale_discount_type' => 'getSaleDiscountType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['downgrade_event_type'] = isset($data['downgrade_event_type']) ? $data['downgrade_event_type'] : null;
        $this->container['plan_information'] = isset($data['plan_information']) ? $data['plan_information'] : null;
        $this->container['promo_code'] = isset($data['promo_code']) ? $data['promo_code'] : null;
        $this->container['sale_discount'] = isset($data['sale_discount']) ? $data['sale_discount'] : null;
        $this->container['sale_discount_periods'] = isset($data['sale_discount_periods']) ? $data['sale_discount_periods'] : null;
        $this->container['sale_discount_type'] = isset($data['sale_discount_type']) ? $data['sale_discount_type'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets downgrade_event_type
     *
     * @return ?string
     */
    public function getDowngradeEventType()
    {
        return $this->container['downgrade_event_type'];
    }

    /**
     * Sets downgrade_event_type
     *
     * @param ?string $downgrade_event_type 
     *
     * @return $this
     */
    public function setDowngradeEventType($downgrade_event_type)
    {
        $this->container['downgrade_event_type'] = $downgrade_event_type;

        return $this;
    }

    /**
     * Gets plan_information
     *
     * @return \DocuSign\eSign\Model\PlanInformation
     */
    public function getPlanInformation()
    {
        return $this->container['plan_information'];
    }

    /**
     * Sets plan_information
     *
     * @param \DocuSign\eSign\Model\PlanInformation $plan_information An object used to identify the features and attributes of the account being created.
     *
     * @return $this
     */
    public function setPlanInformation($plan_information)
    {
        $this->container['plan_information'] = $plan_information;

        return $this;
    }

    /**
     * Gets promo_code
     *
     * @return ?string
     */
    public function getPromoCode()
    {
        return $this->container['promo_code'];
    }

    /**
     * Sets promo_code
     *
     * @param ?string $promo_code 
     *
     * @return $this
     */
    public function setPromoCode($promo_code)
    {
        $this->container['promo_code'] = $promo_code;

        return $this;
    }

    /**
     * Gets sale_discount
     *
     * @return ?string
     */
    public function getSaleDiscount()
    {
        return $this->container['sale_discount'];
    }

    /**
     * Sets sale_discount
     *
     * @param ?string $sale_discount 
     *
     * @return $this
     */
    public function setSaleDiscount($sale_discount)
    {
        $this->container['sale_discount'] = $sale_discount;

        return $this;
    }

    /**
     * Gets sale_discount_periods
     *
     * @return ?string
     */
    public function getSaleDiscountPeriods()
    {
        return $this->container['sale_discount_periods'];
    }

    /**
     * Sets sale_discount_periods
     *
     * @param ?string $sale_discount_periods 
     *
     * @return $this
     */
    public function setSaleDiscountPeriods($sale_discount_periods)
    {
        $this->container['sale_discount_periods'] = $sale_discount_periods;

        return $this;
    }

    /**
     * Gets sale_discount_type
     *
     * @return ?string
     */
    public function getSaleDiscountType()
    {
        return $this->container['sale_discount_type'];
    }

    /**
     * Sets sale_discount_type
     *
     * @param ?string $sale_discount_type 
     *
     * @return $this
     */
    public function setSaleDiscountType($sale_discount_type)
    {
        $this->container['sale_discount_type'] = $sale_discount_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

